/* 
 *  UserRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.UserNotFoundException;
import com.avaya.ccs.api.UserI;
import com.avaya.ccs.api.exceptions.InvalidArgumentException;
import com.avaya.ccs.api.exceptions.ObjectInvalidException;

/**
 * This class is a base class for User requests.
 */
public abstract class UserRequest extends SessionRequest {

    private final String userID;

    public UserRequest(Logger LOG, String userID) {
        super(LOG);
        this.userID = userID;
    }

    /*
    If this methods throws an exeception the base request class will catch it.
     */
    public UserI getUser() throws InvalidArgumentException, ObjectInvalidException, UserNotFoundException {
        UserI user = getSession().findUser(userID);
        if (user == null) {
            throw new UserNotFoundException(userID);
        } else {
            return user;
        }
    }

}
